#!/bin/sh

# panic: in_pcbconnect: inp is already connected
# cpuid = 2
# time = 1687326262
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe016e604b60
# vpanic() at vpanic+0x150/frame 0xfffffe016e604bb0
# panic() at panic+0x43/frame 0xfffffe016e604c10
# in_pcbconnect_setup() at in_pcbconnect_setup/frame 0xfffffe016e604c60
# tcp_connect() at tcp_connect+0xa3/frame 0xfffffe016e604ca0
# tcp_usr_connect() at tcp_usr_connect+0xf3/frame 0xfffffe016e604d10
# soconnectat() at soconnectat+0xaf/frame 0xfffffe016e604d60
# kern_connectat() at kern_connectat+0xe1/frame 0xfffffe016e604dc0
# sys_connect() at sys_connect+0x75/frame 0xfffffe016e604e00
# amd64_syscall() at amd64_syscall+0x157/frame 0xfffffe016e604f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe016e604f30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x823c81a6a, rsp = 0x8210ed3c8, rbp = 0x8210ed3e0 ---
# KDB: enter: panic
# [ thread pid 46907 tid 100356 ]
# Stopped at      kdb_enter+0x32: movq    $0,0xddf693(%rip)
# db> x/s version
# version:        FreeBSD 14.0-CURRENT #0 main-n263725-1efa7dbc0798e: Wed Jun 21 09:13:50 CEST 2023
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO-KASAN\012
# db> 

[ `uname -p` != "amd64" ] && exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=44e3d85e927362a22cc594b9d1d3072f38da7972
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+f0f7871ec5397602b446@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 2ul, 1ul, 0);
  if (res != -1)
    r[0] = res;
  *(uint8_t*)0x200001c0 = 0x10;
  *(uint8_t*)0x200001c1 = 2;
  *(uint16_t*)0x200001c2 = htobe16(0x4e22);
  *(uint32_t*)0x200001c4 = htobe32(0x7f000001);
  memset((void*)0x200001c8, 0, 8);
  syscall(SYS_bind, r[0], 0x200001c0ul, 0x10ul);
  syscall(SYS_listen, r[0], 0);
  res = syscall(SYS_socket, 2ul, 1ul, 0);
  if (res != -1)
    r[1] = res;
  *(uint8_t*)0x200000c0 = 0x10;
  *(uint8_t*)0x200000c1 = 2;
  *(uint16_t*)0x200000c2 = htobe16(0x4e22);
  *(uint32_t*)0x200000c4 = htobe32(0x7f000001);
  memset((void*)0x200000c8, 0, 8);
  syscall(SYS_connect, r[1], 0x200000c0ul, 0x10ul);
  *(uint64_t*)0x20002580 = 0;
  *(uint32_t*)0x20002588 = 0;
  *(uint64_t*)0x20002590 = 0;
  *(uint64_t*)0x20002598 = 0;
  *(uint64_t*)0x200025a0 = 0;
  *(uint64_t*)0x200025a8 = 0;
  *(uint32_t*)0x200025b0 = 0;
  syscall(SYS_sendmsg, r[1], 0x20002580ul, 0x20104ul);
  syscall(SYS_shutdown, r[1], 1ul);
  *(uint8_t*)0x200000c0 = 0x10;
  *(uint8_t*)0x200000c1 = 2;
  *(uint16_t*)0x200000c2 = htobe16(0x4e22);
  *(uint32_t*)0x200000c4 = htobe32(0x7f000001);
  memset((void*)0x200000c8, 0, 8);
  syscall(SYS_connect, r[1], 0x200000c0ul, 0x10ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c || exit 1

(cd /tmp; timeout 2m ./$prog)

rm -rf /tmp/$prog /tmp/$prog.c /tmp/syzkaller.*
exit 0
