#
# SPDX-License-Identifier: BSD-2-Clause
#
# Copyright (c) 2025 FreeBSD Foundation
#
# This sofware was developed by Cy Schubert <cy@FreeBSD.org>
# under sponsorship from the FreeBSD Foundation.
#

.include "../Makefile.inc"

FILESGROPS=	DOCS_HTML \
		DOCS_HTML___STATIC \
		DOCS_HTML_ADMIN \
		DOCS_HTML_ADMIN_ADMIN__COMMANDS \
		DOCS_HTML_ADMIN_ADVANCED \
		DOCS_HTML_ADMIN_CONF__FILES \
		DOCS_HTML_APPDEV \
		DOCS_HTML_APPDEV_REFS \
		DOCS_HTML_APPDEV_REFS_API \
		DOCS_HTML_APPDEV_REFS_MACROS \
		DOCS_HTML_APPDEV_REFS_TYPES \
		DOCS_HTML_BASIC \
		DOCS_HTML_BUILD \
		DOCS_HTML_FORMATS \
		DOCS_HTML_PLUGINDEV \
		DOCS_HTML_USER \
		DOCS_HTML_USER_USER__COMMANDS \
		DOCS_HTML_USER_USER__CONFIG

DOCS_HTMLDIR=				${KRB5_HTMLDOCSDIR}
DOCS_HTML___STATICDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_ADMINDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_ADMIN_ADMIN__COMMANDSDIR=	${KRB5_HTMLDOCSDIR}
DOCS_HTML_ADMIN_ADVANCEDDIR=		${KRB5_HTMLDOCSDIR}
DOCS_HTML_ADMIN_CONF__FILESDIR=		${KRB5_HTMLDOCSDIR}
DOCS_HTML_APPDEVDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_APPDEV_REFSDIR=		${KRB5_HTMLDOCSDIR}
DOCS_HTML_APPDEV_REFS_APIDIR=		${KRB5_HTMLDOCSDIR}
DOCS_HTML_APPDEV_REFS_MACROSDIR=	${KRB5_HTMLDOCSDIR}
DOCS_HTML_APPDEV_REFS_TYPESDIR=		${KRB5_HTMLDOCSDIR}
DOCS_HTML_BASICDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_BUILDDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_FORMATSDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_PLUGINDEVDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_USERDIR=			${KRB5_HTMLDOCSDIR}
DOCS_HTML_USER_USER__COMMANDSDIR=	${KRB5_HTMLDOCSDIR}
DOCS_HTML_USER_USER__CONFIGDIR=		${KRB5_HTMLDOCSDIR}

DOCS_HTML=	\
	about.html \
	build_this.html \
	copyright.html \
	genindex-A.html \
	genindex-C.html \
	genindex-E.html \
	genindex-K.html \
	genindex-L.html \
	genindex-M.html \
	genindex-P.html \
	genindex-R.html \
	genindex-S.html \
	genindex-T.html \
	genindex-V.html \
	genindex-all.html \
	genindex.html \
	index.html \
	mitK5defaults.html \
	mitK5features.html \
	mitK5license.html \
	objects.inv \
	resources.html \
	search.html \
	searchindex.js

DOCS_HTML___STATIC=	\
	agogo.css \
	basic.css \
	bgfooter.png \
	bgtop.png \
	doctools.js \
	documentation_options.js \
	file.png \
	jquery.js \
	kerb.css \
	language_data.js \
	minus.png \
	plus.png \
	pygments.css \
	searchtools.js \
	underscore.js

DOCS_HTML_ADMIN=	\
	appl_servers.html \
	auth_indicator.html \
	backup_host.html \
	conf_ldap.html \
	database.html \
	dbtypes.html \
	dictionary.html \
	enctypes.html \
	env_variables.html \
	host_config.html \
	https.html \
	index.html \
	install.html \
	install_appl_srv.html \
	install_clients.html \
	install_kdc.html \
	lockout.html \
	otp.html \
	pkinit.html \
	princ_dns.html \
	realm_config.html \
	spake.html \
	troubleshoot.html \
	various_envs.html

DOCS_HTML_ADMIN_ADMIN__COMMANDS=	\
	index.html \
	k5srvutil.html \
	kadmin_local.html \
	kadmind.html \
	kdb5_ldap_util.html \
	kdb5_util.html \
	kprop.html \
	kpropd.html \
	kproplog.html \
	krb5kdc.html \
	ktutil.html \
	sserver.html

DOCS_HTML_ADMIN_ADVANCED=	\
	index.html \
	retiring-des.html

DOCS_HTML_ADMIN_CONF__FILES=	\
	index.html \
	kadm5_acl.html \
	kdc_conf.html \
	krb5_conf.html

DOCS_HTML_APPDEV=	\
	gssapi.html \
	h5l_mit_apidiff.html \
	index.html \
	init_creds.html \
	princ_handle.html \
	y2038.html

DOCS_HTML_APPDEV_REFS=	\
	index.html

DOCS_HTML_APPDEV_REFS_API= \
	index.html \
	krb5_425_conv_principal.html \
	krb5_524_conv_principal.html \
	krb5_524_convert_creds.html \
	krb5_address_compare.html \
	krb5_address_order.html \
	krb5_address_search.html \
	krb5_allow_weak_crypto.html \
	krb5_aname_to_localname.html \
	krb5_anonymous_principal.html \
	krb5_anonymous_realm.html \
	krb5_appdefault_boolean.html \
	krb5_appdefault_string.html \
	krb5_auth_con_free.html \
	krb5_auth_con_genaddrs.html \
	krb5_auth_con_get_checksum_func.html \
	krb5_auth_con_getaddrs.html \
	krb5_auth_con_getauthenticator.html \
	krb5_auth_con_getflags.html \
	krb5_auth_con_getkey.html \
	krb5_auth_con_getkey_k.html \
	krb5_auth_con_getlocalseqnumber.html \
	krb5_auth_con_getlocalsubkey.html \
	krb5_auth_con_getrcache.html \
	krb5_auth_con_getrecvsubkey.html \
	krb5_auth_con_getrecvsubkey_k.html \
	krb5_auth_con_getremoteseqnumber.html \
	krb5_auth_con_getremotesubkey.html \
	krb5_auth_con_getsendsubkey.html \
	krb5_auth_con_getsendsubkey_k.html \
	krb5_auth_con_init.html \
	krb5_auth_con_initivector.html \
	krb5_auth_con_set_checksum_func.html \
	krb5_auth_con_set_req_cksumtype.html \
	krb5_auth_con_setaddrs.html \
	krb5_auth_con_setflags.html \
	krb5_auth_con_setports.html \
	krb5_auth_con_setrcache.html \
	krb5_auth_con_setrecvsubkey.html \
	krb5_auth_con_setrecvsubkey_k.html \
	krb5_auth_con_setsendsubkey.html \
	krb5_auth_con_setsendsubkey_k.html \
	krb5_auth_con_setuseruserkey.html \
	krb5_build_principal.html \
	krb5_build_principal_alloc_va.html \
	krb5_build_principal_ext.html \
	krb5_build_principal_va.html \
	krb5_c_block_size.html \
	krb5_c_checksum_length.html \
	krb5_c_crypto_length.html \
	krb5_c_crypto_length_iov.html \
	krb5_c_decrypt.html \
	krb5_c_decrypt_iov.html \
	krb5_c_derive_prfplus.html \
	krb5_c_encrypt.html \
	krb5_c_encrypt_iov.html \
	krb5_c_encrypt_length.html \
	krb5_c_enctype_compare.html \
	krb5_c_free_state.html \
	krb5_c_fx_cf2_simple.html \
	krb5_c_init_state.html \
	krb5_c_is_coll_proof_cksum.html \
	krb5_c_is_keyed_cksum.html \
	krb5_c_keyed_checksum_types.html \
	krb5_c_keylengths.html \
	krb5_c_make_checksum.html \
	krb5_c_make_checksum_iov.html \
	krb5_c_make_random_key.html \
	krb5_c_padding_length.html \
	krb5_c_prf.html \
	krb5_c_prf_length.html \
	krb5_c_prfplus.html \
	krb5_c_random_add_entropy.html \
	krb5_c_random_make_octets.html \
	krb5_c_random_os_entropy.html \
	krb5_c_random_seed.html \
	krb5_c_random_to_key.html \
	krb5_c_string_to_key.html \
	krb5_c_string_to_key_with_params.html \
	krb5_c_valid_cksumtype.html \
	krb5_c_valid_enctype.html \
	krb5_c_verify_checksum.html \
	krb5_c_verify_checksum_iov.html \
	krb5_calculate_checksum.html \
	krb5_cc_cache_match.html \
	krb5_cc_close.html \
	krb5_cc_copy_creds.html \
	krb5_cc_default.html \
	krb5_cc_default_name.html \
	krb5_cc_destroy.html \
	krb5_cc_dup.html \
	krb5_cc_end_seq_get.html \
	krb5_cc_gen_new.html \
	krb5_cc_get_config.html \
	krb5_cc_get_flags.html \
	krb5_cc_get_full_name.html \
	krb5_cc_get_name.html \
	krb5_cc_get_principal.html \
	krb5_cc_get_type.html \
	krb5_cc_initialize.html \
	krb5_cc_move.html \
	krb5_cc_new_unique.html \
	krb5_cc_next_cred.html \
	krb5_cc_remove_cred.html \
	krb5_cc_resolve.html \
	krb5_cc_retrieve_cred.html \
	krb5_cc_select.html \
	krb5_cc_set_config.html \
	krb5_cc_set_default_name.html \
	krb5_cc_set_flags.html \
	krb5_cc_start_seq_get.html \
	krb5_cc_store_cred.html \
	krb5_cc_support_switch.html \
	krb5_cc_switch.html \
	krb5_cccol_cursor_free.html \
	krb5_cccol_cursor_new.html \
	krb5_cccol_cursor_next.html \
	krb5_cccol_have_content.html \
	krb5_change_password.html \
	krb5_check_clockskew.html \
	krb5_checksum_size.html \
	krb5_chpw_message.html \
	krb5_cksumtype_to_string.html \
	krb5_clear_error_message.html \
	krb5_copy_addresses.html \
	krb5_copy_authdata.html \
	krb5_copy_authenticator.html \
	krb5_copy_checksum.html \
	krb5_copy_context.html \
	krb5_copy_creds.html \
	krb5_copy_data.html \
	krb5_copy_error_message.html \
	krb5_copy_keyblock.html \
	krb5_copy_keyblock_contents.html \
	krb5_copy_principal.html \
	krb5_copy_ticket.html \
	krb5_decode_authdata_container.html \
	krb5_decode_ticket.html \
	krb5_decrypt.html \
	krb5_deltat_to_string.html \
	krb5_eblock_enctype.html \
	krb5_encode_authdata_container.html \
	krb5_encrypt.html \
	krb5_encrypt_size.html \
	krb5_enctype_to_name.html \
	krb5_enctype_to_string.html \
	krb5_expand_hostname.html \
	krb5_find_authdata.html \
	krb5_finish_key.html \
	krb5_finish_random_key.html \
	krb5_free_addresses.html \
	krb5_free_ap_rep_enc_part.html \
	krb5_free_authdata.html \
	krb5_free_authenticator.html \
	krb5_free_checksum.html \
	krb5_free_checksum_contents.html \
	krb5_free_cksumtypes.html \
	krb5_free_context.html \
	krb5_free_cred_contents.html \
	krb5_free_creds.html \
	krb5_free_data.html \
	krb5_free_data_contents.html \
	krb5_free_default_realm.html \
	krb5_free_enctypes.html \
	krb5_free_error.html \
	krb5_free_error_message.html \
	krb5_free_host_realm.html \
	krb5_free_keyblock.html \
	krb5_free_keyblock_contents.html \
	krb5_free_keytab_entry_contents.html \
	krb5_free_principal.html \
	krb5_free_string.html \
	krb5_free_tgt_creds.html \
	krb5_free_ticket.html \
	krb5_free_unparsed_name.html \
	krb5_fwd_tgt_creds.html \
	krb5_get_credentials.html \
	krb5_get_credentials_renew.html \
	krb5_get_credentials_validate.html \
	krb5_get_default_realm.html \
	krb5_get_error_message.html \
	krb5_get_etype_info.html \
	krb5_get_fallback_host_realm.html \
	krb5_get_host_realm.html \
	krb5_get_in_tkt_with_keytab.html \
	krb5_get_in_tkt_with_password.html \
	krb5_get_in_tkt_with_skey.html \
	krb5_get_init_creds_keytab.html \
	krb5_get_init_creds_opt_alloc.html \
	krb5_get_init_creds_opt_free.html \
	krb5_get_init_creds_opt_get_fast_flags.html \
	krb5_get_init_creds_opt_init.html \
	krb5_get_init_creds_opt_set_address_list.html \
	krb5_get_init_creds_opt_set_anonymous.html \
	krb5_get_init_creds_opt_set_canonicalize.html \
	krb5_get_init_creds_opt_set_change_password_prompt.html \
	krb5_get_init_creds_opt_set_etype_list.html \
	krb5_get_init_creds_opt_set_expire_callback.html \
	krb5_get_init_creds_opt_set_fast_ccache.html \
	krb5_get_init_creds_opt_set_fast_ccache_name.html \
	krb5_get_init_creds_opt_set_fast_flags.html \
	krb5_get_init_creds_opt_set_forwardable.html \
	krb5_get_init_creds_opt_set_in_ccache.html \
	krb5_get_init_creds_opt_set_out_ccache.html \
	krb5_get_init_creds_opt_set_pa.html \
	krb5_get_init_creds_opt_set_pac_request.html \
	krb5_get_init_creds_opt_set_preauth_list.html \
	krb5_get_init_creds_opt_set_proxiable.html \
	krb5_get_init_creds_opt_set_renew_life.html \
	krb5_get_init_creds_opt_set_responder.html \
	krb5_get_init_creds_opt_set_salt.html \
	krb5_get_init_creds_opt_set_tkt_life.html \
	krb5_get_init_creds_password.html \
	krb5_get_permitted_enctypes.html \
	krb5_get_profile.html \
	krb5_get_prompt_types.html \
	krb5_get_renewed_creds.html \
	krb5_get_server_rcache.html \
	krb5_get_time_offsets.html \
	krb5_get_validated_creds.html \
	krb5_init_context.html \
	krb5_init_context_profile.html \
	krb5_init_creds_free.html \
	krb5_init_creds_get.html \
	krb5_init_creds_get_creds.html \
	krb5_init_creds_get_error.html \
	krb5_init_creds_get_times.html \
	krb5_init_creds_init.html \
	krb5_init_creds_set_keytab.html \
	krb5_init_creds_set_password.html \
	krb5_init_creds_set_service.html \
	krb5_init_creds_step.html \
	krb5_init_keyblock.html \
	krb5_init_random_key.html \
	krb5_init_secure_context.html \
	krb5_is_config_principal.html \
	krb5_is_referral_realm.html \
	krb5_is_thread_safe.html \
	krb5_k_create_key.html \
	krb5_k_decrypt.html \
	krb5_k_decrypt_iov.html \
	krb5_k_encrypt.html \
	krb5_k_encrypt_iov.html \
	krb5_k_free_key.html \
	krb5_k_key_enctype.html \
	krb5_k_key_keyblock.html \
	krb5_k_make_checksum.html \
	krb5_k_make_checksum_iov.html \
	krb5_k_prf.html \
	krb5_k_reference_key.html \
	krb5_k_verify_checksum.html \
	krb5_k_verify_checksum_iov.html \
	krb5_kdc_sign_ticket.html \
	krb5_kdc_verify_ticket.html \
	krb5_kt_add_entry.html \
	krb5_kt_client_default.html \
	krb5_kt_close.html \
	krb5_kt_default.html \
	krb5_kt_default_name.html \
	krb5_kt_dup.html \
	krb5_kt_end_seq_get.html \
	krb5_kt_free_entry.html \
	krb5_kt_get_entry.html \
	krb5_kt_get_name.html \
	krb5_kt_get_type.html \
	krb5_kt_have_content.html \
	krb5_kt_next_entry.html \
	krb5_kt_read_service_key.html \
	krb5_kt_remove_entry.html \
	krb5_kt_resolve.html \
	krb5_kt_start_seq_get.html \
	krb5_kuserok.html \
	krb5_make_authdata_kdc_issued.html \
	krb5_marshal_credentials.html \
	krb5_merge_authdata.html \
	krb5_mk_1cred.html \
	krb5_mk_error.html \
	krb5_mk_ncred.html \
	krb5_mk_priv.html \
	krb5_mk_rep.html \
	krb5_mk_rep_dce.html \
	krb5_mk_req.html \
	krb5_mk_req_extended.html \
	krb5_mk_safe.html \
	krb5_os_localaddr.html \
	krb5_pac_add_buffer.html \
	krb5_pac_free.html \
	krb5_pac_get_buffer.html \
	krb5_pac_get_client_info.html \
	krb5_pac_get_types.html \
	krb5_pac_init.html \
	krb5_pac_parse.html \
	krb5_pac_sign.html \
	krb5_pac_sign_ext.html \
	krb5_pac_verify.html \
	krb5_pac_verify_ext.html \
	krb5_parse_name.html \
	krb5_parse_name_flags.html \
	krb5_prepend_error_message.html \
	krb5_principal2salt.html \
	krb5_principal_compare.html \
	krb5_principal_compare_any_realm.html \
	krb5_principal_compare_flags.html \
	krb5_process_key.html \
	krb5_prompter_posix.html \
	krb5_random_key.html \
	krb5_rd_cred.html \
	krb5_rd_error.html \
	krb5_rd_priv.html \
	krb5_rd_rep.html \
	krb5_rd_rep_dce.html \
	krb5_rd_req.html \
	krb5_rd_safe.html \
	krb5_read_password.html \
	krb5_realm_compare.html \
	krb5_recvauth.html \
	krb5_recvauth_version.html \
	krb5_responder_get_challenge.html \
	krb5_responder_list_questions.html \
	krb5_responder_otp_challenge_free.html \
	krb5_responder_otp_get_challenge.html \
	krb5_responder_otp_set_answer.html \
	krb5_responder_pkinit_challenge_free.html \
	krb5_responder_pkinit_get_challenge.html \
	krb5_responder_pkinit_set_answer.html \
	krb5_responder_set_answer.html \
	krb5_salttype_to_string.html \
	krb5_sendauth.html \
	krb5_server_decrypt_ticket_keytab.html \
	krb5_set_default_realm.html \
	krb5_set_default_tgs_enctypes.html \
	krb5_set_error_message.html \
	krb5_set_kdc_recv_hook.html \
	krb5_set_kdc_send_hook.html \
	krb5_set_password.html \
	krb5_set_password_using_ccache.html \
	krb5_set_principal_realm.html \
	krb5_set_real_time.html \
	krb5_set_trace_callback.html \
	krb5_set_trace_filename.html \
	krb5_sname_match.html \
	krb5_sname_to_principal.html \
	krb5_string_to_cksumtype.html \
	krb5_string_to_deltat.html \
	krb5_string_to_enctype.html \
	krb5_string_to_key.html \
	krb5_string_to_salttype.html \
	krb5_string_to_timestamp.html \
	krb5_timeofday.html \
	krb5_timestamp_to_sfstring.html \
	krb5_timestamp_to_string.html \
	krb5_tkt_creds_free.html \
	krb5_tkt_creds_get.html \
	krb5_tkt_creds_get_creds.html \
	krb5_tkt_creds_get_times.html \
	krb5_tkt_creds_init.html \
	krb5_tkt_creds_step.html \
	krb5_unmarshal_credentials.html \
	krb5_unparse_name.html \
	krb5_unparse_name_ext.html \
	krb5_unparse_name_flags.html \
	krb5_unparse_name_flags_ext.html \
	krb5_us_timeofday.html \
	krb5_use_enctype.html \
	krb5_verify_authdata_kdc_issued.html \
	krb5_verify_checksum.html \
	krb5_verify_init_creds.html \
	krb5_verify_init_creds_opt_init.html \
	krb5_verify_init_creds_opt_set_ap_req_nofail.html \
	krb5_vprepend_error_message.html \
	krb5_vset_error_message.html \
	krb5_vwrap_error_message.html \
	krb5_wrap_error_message.html

DOCS_HTML_APPDEV_REFS_MACROS= \
	ADDRTYPE_ADDRPORT.html \
	ADDRTYPE_CHAOS.html \
	ADDRTYPE_DDP.html \
	ADDRTYPE_INET.html \
	ADDRTYPE_INET6.html \
	ADDRTYPE_IPPORT.html \
	ADDRTYPE_ISO.html \
	ADDRTYPE_IS_LOCAL.html \
	ADDRTYPE_NETBIOS.html \
	ADDRTYPE_XNS.html \
	AD_TYPE_EXTERNAL.html \
	AD_TYPE_FIELD_TYPE_MASK.html \
	AD_TYPE_REGISTERED.html \
	AD_TYPE_RESERVED.html \
	AP_OPTS_ETYPE_NEGOTIATION.html \
	AP_OPTS_MUTUAL_REQUIRED.html \
	AP_OPTS_RESERVED.html \
	AP_OPTS_USE_SESSION_KEY.html \
	AP_OPTS_USE_SUBKEY.html \
	AP_OPTS_WIRE_MASK.html \
	CKSUMTYPE_CMAC_CAMELLIA128.html \
	CKSUMTYPE_CMAC_CAMELLIA256.html \
	CKSUMTYPE_CRC32.html \
	CKSUMTYPE_DESCBC.html \
	CKSUMTYPE_HMAC_MD5_ARCFOUR.html \
	CKSUMTYPE_HMAC_SHA1_96_AES128.html \
	CKSUMTYPE_HMAC_SHA1_96_AES256.html \
	CKSUMTYPE_HMAC_SHA1_DES3.html \
	CKSUMTYPE_HMAC_SHA256_128_AES128.html \
	CKSUMTYPE_HMAC_SHA384_192_AES256.html \
	CKSUMTYPE_MD5_HMAC_ARCFOUR.html \
	CKSUMTYPE_NIST_SHA.html \
	CKSUMTYPE_RSA_MD4.html \
	CKSUMTYPE_RSA_MD4_DES.html \
	CKSUMTYPE_RSA_MD5.html \
	CKSUMTYPE_RSA_MD5_DES.html \
	CKSUMTYPE_SHA1.html \
	ENCTYPE_AES128_CTS_HMAC_SHA1_96.html \
	ENCTYPE_AES128_CTS_HMAC_SHA256_128.html \
	ENCTYPE_AES256_CTS_HMAC_SHA1_96.html \
	ENCTYPE_AES256_CTS_HMAC_SHA384_192.html \
	ENCTYPE_ARCFOUR_HMAC.html \
	ENCTYPE_ARCFOUR_HMAC_EXP.html \
	ENCTYPE_CAMELLIA128_CTS_CMAC.html \
	ENCTYPE_CAMELLIA256_CTS_CMAC.html \
	ENCTYPE_DES3_CBC_ENV.html \
	ENCTYPE_DES3_CBC_RAW.html \
	ENCTYPE_DES3_CBC_SHA.html \
	ENCTYPE_DES3_CBC_SHA1.html \
	ENCTYPE_DES_CBC_CRC.html \
	ENCTYPE_DES_CBC_MD4.html \
	ENCTYPE_DES_CBC_MD5.html \
	ENCTYPE_DES_CBC_RAW.html \
	ENCTYPE_DES_HMAC_SHA1.html \
	ENCTYPE_DSA_SHA1_CMS.html \
	ENCTYPE_MD5_RSA_CMS.html \
	ENCTYPE_NULL.html \
	ENCTYPE_RC2_CBC_ENV.html \
	ENCTYPE_RSA_ENV.html \
	ENCTYPE_RSA_ES_OAEP_ENV.html \
	ENCTYPE_SHA1_RSA_CMS.html \
	ENCTYPE_UNKNOWN.html \
	KDC_OPT_ALLOW_POSTDATE.html \
	KDC_OPT_CANONICALIZE.html \
	KDC_OPT_CNAME_IN_ADDL_TKT.html \
	KDC_OPT_DISABLE_TRANSITED_CHECK.html \
	KDC_OPT_ENC_TKT_IN_SKEY.html \
	KDC_OPT_FORWARDABLE.html \
	KDC_OPT_FORWARDED.html \
	KDC_OPT_POSTDATED.html \
	KDC_OPT_PROXIABLE.html \
	KDC_OPT_PROXY.html \
	KDC_OPT_RENEW.html \
	KDC_OPT_RENEWABLE.html \
	KDC_OPT_RENEWABLE_OK.html \
	KDC_OPT_REQUEST_ANONYMOUS.html \
	KDC_OPT_VALIDATE.html \
	KDC_TKT_COMMON_MASK.html \
	KRB5_ALTAUTH_ATT_CHALLENGE_RESPONSE.html \
	KRB5_ANONYMOUS_PRINCSTR.html \
	KRB5_ANONYMOUS_REALMSTR.html \
	KRB5_AP_REP.html \
	KRB5_AP_REQ.html \
	KRB5_AS_REP.html \
	KRB5_AS_REQ.html \
	KRB5_AUTHDATA_AND_OR.html \
	KRB5_AUTHDATA_AP_OPTIONS.html \
	KRB5_AUTHDATA_AUTH_INDICATOR.html \
	KRB5_AUTHDATA_CAMMAC.html \
	KRB5_AUTHDATA_ETYPE_NEGOTIATION.html \
	KRB5_AUTHDATA_FX_ARMOR.html \
	KRB5_AUTHDATA_IF_RELEVANT.html \
	KRB5_AUTHDATA_INITIAL_VERIFIED_CAS.html \
	KRB5_AUTHDATA_KDC_ISSUED.html \
	KRB5_AUTHDATA_MANDATORY_FOR_KDC.html \
	KRB5_AUTHDATA_OSF_DCE.html \
	KRB5_AUTHDATA_SESAME.html \
	KRB5_AUTHDATA_SIGNTICKET.html \
	KRB5_AUTHDATA_WIN2K_PAC.html \
	KRB5_AUTH_CONTEXT_DO_SEQUENCE.html \
	KRB5_AUTH_CONTEXT_DO_TIME.html \
	KRB5_AUTH_CONTEXT_GENERATE_LOCAL_ADDR.html \
	KRB5_AUTH_CONTEXT_GENERATE_LOCAL_FULL_ADDR.html \
	KRB5_AUTH_CONTEXT_GENERATE_REMOTE_ADDR.html \
	KRB5_AUTH_CONTEXT_GENERATE_REMOTE_FULL_ADDR.html \
	KRB5_AUTH_CONTEXT_PERMIT_ALL.html \
	KRB5_AUTH_CONTEXT_RET_SEQUENCE.html \
	KRB5_AUTH_CONTEXT_RET_TIME.html \
	KRB5_AUTH_CONTEXT_USE_SUBKEY.html \
	KRB5_CRED.html \
	KRB5_CRYPTO_TYPE_CHECKSUM.html \
	KRB5_CRYPTO_TYPE_DATA.html \
	KRB5_CRYPTO_TYPE_EMPTY.html \
	KRB5_CRYPTO_TYPE_HEADER.html \
	KRB5_CRYPTO_TYPE_PADDING.html \
	KRB5_CRYPTO_TYPE_SIGN_ONLY.html \
	KRB5_CRYPTO_TYPE_STREAM.html \
	KRB5_CRYPTO_TYPE_TRAILER.html \
	KRB5_CYBERSAFE_SECUREID.html \
	KRB5_DOMAIN_X500_COMPRESS.html \
	KRB5_ENCPADATA_REQ_ENC_PA_REP.html \
	KRB5_ERROR.html \
	KRB5_FAST_REQUIRED.html \
	KRB5_GC_CACHED.html \
	KRB5_GC_CANONICALIZE.html \
	KRB5_GC_CONSTRAINED_DELEGATION.html \
	KRB5_GC_FORWARDABLE.html \
	KRB5_GC_NO_STORE.html \
	KRB5_GC_NO_TRANSIT_CHECK.html \
	KRB5_GC_USER_USER.html \
	KRB5_GET_INIT_CREDS_OPT_ADDRESS_LIST.html \
	KRB5_GET_INIT_CREDS_OPT_ANONYMOUS.html \
	KRB5_GET_INIT_CREDS_OPT_CANONICALIZE.html \
	KRB5_GET_INIT_CREDS_OPT_CHG_PWD_PRMPT.html \
	KRB5_GET_INIT_CREDS_OPT_ETYPE_LIST.html \
	KRB5_GET_INIT_CREDS_OPT_FORWARDABLE.html \
	KRB5_GET_INIT_CREDS_OPT_PREAUTH_LIST.html \
	KRB5_GET_INIT_CREDS_OPT_PROXIABLE.html \
	KRB5_GET_INIT_CREDS_OPT_RENEW_LIFE.html \
	KRB5_GET_INIT_CREDS_OPT_SALT.html \
	KRB5_GET_INIT_CREDS_OPT_TKT_LIFE.html \
	KRB5_INIT_CONTEXT_KDC.html \
	KRB5_INIT_CONTEXT_SECURE.html \
	KRB5_INIT_CREDS_STEP_FLAG_CONTINUE.html \
	KRB5_INT16_MAX.html \
	KRB5_INT16_MIN.html \
	KRB5_INT32_MAX.html \
	KRB5_INT32_MIN.html \
	KRB5_KEYUSAGE_AD_ITE.html \
	KRB5_KEYUSAGE_AD_KDCISSUED_CKSUM.html \
	KRB5_KEYUSAGE_AD_MTE.html \
	KRB5_KEYUSAGE_AD_SIGNEDPATH.html \
	KRB5_KEYUSAGE_APP_DATA_CKSUM.html \
	KRB5_KEYUSAGE_APP_DATA_ENCRYPT.html \
	KRB5_KEYUSAGE_AP_REP_ENCPART.html \
	KRB5_KEYUSAGE_AP_REQ_AUTH.html \
	KRB5_KEYUSAGE_AP_REQ_AUTH_CKSUM.html \
	KRB5_KEYUSAGE_AS_REP_ENCPART.html \
	KRB5_KEYUSAGE_AS_REQ.html \
	KRB5_KEYUSAGE_AS_REQ_PA_ENC_TS.html \
	KRB5_KEYUSAGE_CAMMAC.html \
	KRB5_KEYUSAGE_ENC_CHALLENGE_CLIENT.html \
	KRB5_KEYUSAGE_ENC_CHALLENGE_KDC.html \
	KRB5_KEYUSAGE_FAST_ENC.html \
	KRB5_KEYUSAGE_FAST_FINISHED.html \
	KRB5_KEYUSAGE_FAST_REP.html \
	KRB5_KEYUSAGE_FAST_REQ_CHKSUM.html \
	KRB5_KEYUSAGE_GSS_TOK_MIC.html \
	KRB5_KEYUSAGE_GSS_TOK_WRAP_INTEG.html \
	KRB5_KEYUSAGE_GSS_TOK_WRAP_PRIV.html \
	KRB5_KEYUSAGE_IAKERB_FINISHED.html \
	KRB5_KEYUSAGE_KDC_REP_TICKET.html \
	KRB5_KEYUSAGE_KRB_CRED_ENCPART.html \
	KRB5_KEYUSAGE_KRB_ERROR_CKSUM.html \
	KRB5_KEYUSAGE_KRB_PRIV_ENCPART.html \
	KRB5_KEYUSAGE_KRB_SAFE_CKSUM.html \
	KRB5_KEYUSAGE_PA_AS_FRESHNESS.html \
	KRB5_KEYUSAGE_PA_FX_COOKIE.html \
	KRB5_KEYUSAGE_PA_OTP_REQUEST.html \
	KRB5_KEYUSAGE_PA_PKINIT_KX.html \
	KRB5_KEYUSAGE_PA_S4U_X509_USER_REPLY.html \
	KRB5_KEYUSAGE_PA_S4U_X509_USER_REQUEST.html \
	KRB5_KEYUSAGE_PA_SAM_CHALLENGE_CKSUM.html \
	KRB5_KEYUSAGE_PA_SAM_CHALLENGE_TRACKID.html \
	KRB5_KEYUSAGE_PA_SAM_RESPONSE.html \
	KRB5_KEYUSAGE_SPAKE.html \
	KRB5_KEYUSAGE_TGS_REP_ENCPART_SESSKEY.html \
	KRB5_KEYUSAGE_TGS_REP_ENCPART_SUBKEY.html \
	KRB5_KEYUSAGE_TGS_REQ_AD_SESSKEY.html \
	KRB5_KEYUSAGE_TGS_REQ_AD_SUBKEY.html \
	KRB5_KEYUSAGE_TGS_REQ_AUTH.html \
	KRB5_KEYUSAGE_TGS_REQ_AUTH_CKSUM.html \
	KRB5_KPASSWD_ACCESSDENIED.html \
	KRB5_KPASSWD_AUTHERROR.html \
	KRB5_KPASSWD_BAD_VERSION.html \
	KRB5_KPASSWD_HARDERROR.html \
	KRB5_KPASSWD_INITIAL_FLAG_NEEDED.html \
	KRB5_KPASSWD_MALFORMED.html \
	KRB5_KPASSWD_SOFTERROR.html \
	KRB5_KPASSWD_SUCCESS.html \
	KRB5_LRQ_ALL_ACCT_EXPTIME.html \
	KRB5_LRQ_ALL_LAST_INITIAL.html \
	KRB5_LRQ_ALL_LAST_RENEWAL.html \
	KRB5_LRQ_ALL_LAST_REQ.html \
	KRB5_LRQ_ALL_LAST_TGT.html \
	KRB5_LRQ_ALL_LAST_TGT_ISSUED.html \
	KRB5_LRQ_ALL_PW_EXPTIME.html \
	KRB5_LRQ_NONE.html \
	KRB5_LRQ_ONE_ACCT_EXPTIME.html \
	KRB5_LRQ_ONE_LAST_INITIAL.html \
	KRB5_LRQ_ONE_LAST_RENEWAL.html \
	KRB5_LRQ_ONE_LAST_REQ.html \
	KRB5_LRQ_ONE_LAST_TGT.html \
	KRB5_LRQ_ONE_LAST_TGT_ISSUED.html \
	KRB5_LRQ_ONE_PW_EXPTIME.html \
	KRB5_NT_ENTERPRISE_PRINCIPAL.html \
	KRB5_NT_ENT_PRINCIPAL_AND_ID.html \
	KRB5_NT_MS_PRINCIPAL.html \
	KRB5_NT_MS_PRINCIPAL_AND_ID.html \
	KRB5_NT_PRINCIPAL.html \
	KRB5_NT_SMTP_NAME.html \
	KRB5_NT_SRV_HST.html \
	KRB5_NT_SRV_INST.html \
	KRB5_NT_SRV_XHST.html \
	KRB5_NT_UID.html \
	KRB5_NT_UNKNOWN.html \
	KRB5_NT_WELLKNOWN.html \
	KRB5_NT_X500_PRINCIPAL.html \
	KRB5_PAC_ATTRIBUTES_INFO.html \
	KRB5_PAC_CLIENT_CLAIMS.html \
	KRB5_PAC_CLIENT_INFO.html \
	KRB5_PAC_CREDENTIALS_INFO.html \
	KRB5_PAC_DELEGATION_INFO.html \
	KRB5_PAC_DEVICE_CLAIMS.html \
	KRB5_PAC_DEVICE_INFO.html \
	KRB5_PAC_FULL_CHECKSUM.html \
	KRB5_PAC_LOGON_INFO.html \
	KRB5_PAC_PRIVSVR_CHECKSUM.html \
	KRB5_PAC_REQUESTOR.html \
	KRB5_PAC_SERVER_CHECKSUM.html \
	KRB5_PAC_TICKET_CHECKSUM.html \
	KRB5_PAC_UPN_DNS_INFO.html \
	KRB5_PADATA_AFS3_SALT.html \
	KRB5_PADATA_AP_REQ.html \
	KRB5_PADATA_AS_CHECKSUM.html \
	KRB5_PADATA_AS_FRESHNESS.html \
	KRB5_PADATA_ENCRYPTED_CHALLENGE.html \
	KRB5_PADATA_ENC_SANDIA_SECURID.html \
	KRB5_PADATA_ENC_TIMESTAMP.html \
	KRB5_PADATA_ENC_UNIX_TIME.html \
	KRB5_PADATA_ETYPE_INFO.html \
	KRB5_PADATA_ETYPE_INFO2.html \
	KRB5_PADATA_FOR_USER.html \
	KRB5_PADATA_FX_COOKIE.html \
	KRB5_PADATA_FX_ERROR.html \
	KRB5_PADATA_FX_FAST.html \
	KRB5_PADATA_GET_FROM_TYPED_DATA.html \
	KRB5_PADATA_NONE.html \
	KRB5_PADATA_OSF_DCE.html \
	KRB5_PADATA_OTP_CHALLENGE.html \
	KRB5_PADATA_OTP_PIN_CHANGE.html \
	KRB5_PADATA_OTP_REQUEST.html \
	KRB5_PADATA_PAC_OPTIONS.html \
	KRB5_PADATA_PAC_REQUEST.html \
	KRB5_PADATA_PKINIT_KX.html \
	KRB5_PADATA_PK_AS_REP.html \
	KRB5_PADATA_PK_AS_REP_OLD.html \
	KRB5_PADATA_PK_AS_REQ.html \
	KRB5_PADATA_PK_AS_REQ_OLD.html \
	KRB5_PADATA_PW_SALT.html \
	KRB5_PADATA_REDHAT_IDP_OAUTH2.html \
	KRB5_PADATA_REDHAT_PASSKEY.html \
	KRB5_PADATA_REFERRAL.html \
	KRB5_PADATA_S4U_X509_USER.html \
	KRB5_PADATA_SAM_CHALLENGE.html \
	KRB5_PADATA_SAM_CHALLENGE_2.html \
	KRB5_PADATA_SAM_REDIRECT.html \
	KRB5_PADATA_SAM_RESPONSE.html \
	KRB5_PADATA_SAM_RESPONSE_2.html \
	KRB5_PADATA_SESAME.html \
	KRB5_PADATA_SPAKE.html \
	KRB5_PADATA_SVR_REFERRAL_INFO.html \
	KRB5_PADATA_TGS_REQ.html \
	KRB5_PADATA_USE_SPECIFIED_KVNO.html \
	KRB5_PRINCIPAL_COMPARE_CASEFOLD.html \
	KRB5_PRINCIPAL_COMPARE_ENTERPRISE.html \
	KRB5_PRINCIPAL_COMPARE_IGNORE_REALM.html \
	KRB5_PRINCIPAL_COMPARE_UTF8.html \
	KRB5_PRINCIPAL_PARSE_ENTERPRISE.html \
	KRB5_PRINCIPAL_PARSE_IGNORE_REALM.html \
	KRB5_PRINCIPAL_PARSE_NO_DEF_REALM.html \
	KRB5_PRINCIPAL_PARSE_NO_REALM.html \
	KRB5_PRINCIPAL_PARSE_REQUIRE_REALM.html \
	KRB5_PRINCIPAL_UNPARSE_DISPLAY.html \
	KRB5_PRINCIPAL_UNPARSE_NO_REALM.html \
	KRB5_PRINCIPAL_UNPARSE_SHORT.html \
	KRB5_PRIV.html \
	KRB5_PROMPT_TYPE_NEW_PASSWORD.html \
	KRB5_PROMPT_TYPE_NEW_PASSWORD_AGAIN.html \
	KRB5_PROMPT_TYPE_PASSWORD.html \
	KRB5_PROMPT_TYPE_PREAUTH.html \
	KRB5_PVNO.html \
	KRB5_REALM_BRANCH_CHAR.html \
	KRB5_RECVAUTH_BADAUTHVERS.html \
	KRB5_RECVAUTH_SKIP_VERSION.html \
	KRB5_REFERRAL_REALM.html \
	KRB5_RESPONDER_OTP_FLAGS_COLLECT_PIN.html \
	KRB5_RESPONDER_OTP_FLAGS_COLLECT_TOKEN.html \
	KRB5_RESPONDER_OTP_FLAGS_NEXTOTP.html \
	KRB5_RESPONDER_OTP_FLAGS_SEPARATE_PIN.html \
	KRB5_RESPONDER_OTP_FORMAT_ALPHANUMERIC.html \
	KRB5_RESPONDER_OTP_FORMAT_DECIMAL.html \
	KRB5_RESPONDER_OTP_FORMAT_HEXADECIMAL.html \
	KRB5_RESPONDER_PKINIT_FLAGS_TOKEN_USER_PIN_COUNT_LOW.html \
	KRB5_RESPONDER_PKINIT_FLAGS_TOKEN_USER_PIN_FINAL_TRY.html \
	KRB5_RESPONDER_PKINIT_FLAGS_TOKEN_USER_PIN_LOCKED.html \
	KRB5_RESPONDER_QUESTION_OTP.html \
	KRB5_RESPONDER_QUESTION_PASSWORD.html \
	KRB5_RESPONDER_QUESTION_PKINIT.html \
	KRB5_SAFE.html \
	KRB5_SAM_MUST_PK_ENCRYPT_SAD.html \
	KRB5_SAM_SEND_ENCRYPTED_SAD.html \
	KRB5_SAM_USE_SAD_AS_KEY.html \
	KRB5_TC_MATCH_2ND_TKT.html \
	KRB5_TC_MATCH_AUTHDATA.html \
	KRB5_TC_MATCH_FLAGS.html \
	KRB5_TC_MATCH_FLAGS_EXACT.html \
	KRB5_TC_MATCH_IS_SKEY.html \
	KRB5_TC_MATCH_KTYPE.html \
	KRB5_TC_MATCH_SRV_NAMEONLY.html \
	KRB5_TC_MATCH_TIMES.html \
	KRB5_TC_MATCH_TIMES_EXACT.html \
	KRB5_TC_NOTICKET.html \
	KRB5_TC_OPENCLOSE.html \
	KRB5_TC_SUPPORTED_KTYPES.html \
	KRB5_TGS_NAME.html \
	KRB5_TGS_NAME_SIZE.html \
	KRB5_TGS_REP.html \
	KRB5_TGS_REQ.html \
	KRB5_TKT_CREDS_STEP_FLAG_CONTINUE.html \
	KRB5_VERIFY_INIT_CREDS_OPT_AP_REQ_NOFAIL.html \
	KRB5_WELLKNOWN_NAMESTR.html \
	LR_TYPE_INTERPRETATION_MASK.html \
	LR_TYPE_THIS_SERVER_ONLY.html \
	MAX_KEYTAB_NAME_LEN.html \
	MSEC_DIRBIT.html \
	MSEC_VAL_MASK.html \
	SALT_TYPE_AFS_LENGTH.html \
	SALT_TYPE_NO_LENGTH.html \
	THREEPARAMOPEN.html \
	TKT_FLG_ANONYMOUS.html \
	TKT_FLG_ENC_PA_REP.html \
	TKT_FLG_FORWARDABLE.html \
	TKT_FLG_FORWARDED.html \
	TKT_FLG_HW_AUTH.html \
	TKT_FLG_INITIAL.html \
	TKT_FLG_INVALID.html \
	TKT_FLG_MAY_POSTDATE.html \
	TKT_FLG_OK_AS_DELEGATE.html \
	TKT_FLG_POSTDATED.html \
	TKT_FLG_PRE_AUTH.html \
	TKT_FLG_PROXIABLE.html \
	TKT_FLG_PROXY.html \
	TKT_FLG_RENEWABLE.html \
	TKT_FLG_TRANSIT_POLICY_CHECKED.html \
	VALID_INT_BITS.html \
	VALID_UINT_BITS.html \
	index.html \
	krb524_convert_creds_kdc.html \
	krb524_init_ets.html \
	krb5_const.html \
	krb5_princ_component.html \
	krb5_princ_name.html \
	krb5_princ_realm.html \
	krb5_princ_set_realm.html \
	krb5_princ_set_realm_data.html \
	krb5_princ_set_realm_length.html \
	krb5_princ_size.html \
	krb5_princ_type.html \
	krb5_roundup.html \
	krb5_x.html \
	krb5_xc.html

DOCS_HTML_APPDEV_REFS_TYPES= \
	index.html \
	krb5_address.html \
	krb5_addrtype.html \
	krb5_ap_rep.html \
	krb5_ap_rep_enc_part.html \
	krb5_ap_req.html \
	krb5_auth_context.html \
	krb5_authdata.html \
	krb5_authdatatype.html \
	krb5_authenticator.html \
	krb5_boolean.html \
	krb5_cc_cursor.html \
	krb5_ccache.html \
	krb5_cccol_cursor.html \
	krb5_checksum.html \
	krb5_cksumtype.html \
	krb5_const_pointer.html \
	krb5_const_principal.html \
	krb5_context.html \
	krb5_cred.html \
	krb5_cred_enc_part.html \
	krb5_cred_info.html \
	krb5_creds.html \
	krb5_crypto_iov.html \
	krb5_cryptotype.html \
	krb5_data.html \
	krb5_deltat.html \
	krb5_enc_data.html \
	krb5_enc_kdc_rep_part.html \
	krb5_enc_tkt_part.html \
	krb5_encrypt_block.html \
	krb5_enctype.html \
	krb5_error.html \
	krb5_error_code.html \
	krb5_expire_callback_func.html \
	krb5_flags.html \
	krb5_get_init_creds_opt.html \
	krb5_gic_opt_pa_data.html \
	krb5_init_creds_context.html \
	krb5_int16.html \
	krb5_int32.html \
	krb5_kdc_rep.html \
	krb5_kdc_req.html \
	krb5_key.html \
	krb5_keyblock.html \
	krb5_keytab.html \
	krb5_keytab_entry.html \
	krb5_keyusage.html \
	krb5_kt_cursor.html \
	krb5_kvno.html \
	krb5_last_req_entry.html \
	krb5_magic.html \
	krb5_mk_req_checksum_func.html \
	krb5_msgtype.html \
	krb5_octet.html \
	krb5_pa_data.html \
	krb5_pa_pac_req.html \
	krb5_pa_server_referral_data.html \
	krb5_pa_svr_referral_data.html \
	krb5_pac.html \
	krb5_pointer.html \
	krb5_post_recv_fn.html \
	krb5_pre_send_fn.html \
	krb5_preauthtype.html \
	krb5_principal.html \
	krb5_principal_data.html \
	krb5_prompt.html \
	krb5_prompt_type.html \
	krb5_prompter_fct.html \
	krb5_pwd_data.html \
	krb5_rcache.html \
	krb5_replay_data.html \
	krb5_responder_context.html \
	krb5_responder_fn.html \
	krb5_responder_otp_challenge.html \
	krb5_responder_otp_tokeninfo.html \
	krb5_responder_pkinit_challenge.html \
	krb5_responder_pkinit_identity.html \
	krb5_response.html \
	krb5_ticket.html \
	krb5_ticket_times.html \
	krb5_timestamp.html \
	krb5_tkt_authent.html \
	krb5_tkt_creds_context.html \
	krb5_trace_callback.html \
	krb5_trace_info.html \
	krb5_transited.html \
	krb5_typed_data.html \
	krb5_ui_2.html \
	krb5_ui_4.html \
	krb5_verify_init_creds_opt.html \
	passwd_phrase_element.html

DOCS_HTML_BASIC=	\
	ccache_def.html \
	date_format.html \
	index.html \
	keytab_def.html \
	rcache_def.html \
	stash_file_def.html

DOCS_HTML_BUILD=	\
	directory_org.html \
	doing_build.html \
	index.html \
	options2configure.html \
	osconf.html

DOCS_HTML_FORMATS=	\
	ccache_file_format.html \
	cookie.html \
	freshness_token.html \
	index.html \
	keytab_file_format.html \
	rcache_file_format.html

DOCS_HTML_PLUGINDEV=	\
	ccselect.html \
	certauth.html \
	clpreauth.html \
	general.html \
	gssapi.html \
	hostrealm.html \
	index.html \
	internal.html \
	kadm5_auth.html \
	kadm5_hook.html \
	kdcpolicy.html \
	kdcpreauth.html \
	localauth.html \
	locate.html \
	profile.html \
	pwqual.html

DOCS_HTML_USER=	\
	index.html \
	pwd_mgmt.html \
	tkt_mgmt.html

DOCS_HTML_USER_USER__COMMANDS=	\
	index.html \
	kdestroy.html \
	kinit.html \
	klist.html \
	kpasswd.html \
	krb5-config.html \
	ksu.html \
	kswitch.html \
	kvno.html \
	sclient.html

DOCS_HTML_USER_USER__CONFIG=	\
	index.html \
	k5identity.html \
	k5login.html \
	kerberos.html
