/*
 * Copyright (c) 2017-2018 Cavium, Inc. 
 * All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __RT_DEFS_H__
#define __RT_DEFS_H__

/* Runtime array offsets */
#define DORQ_REG_PF_MAX_ICID_0_RT_OFFSET                            	0
#define DORQ_REG_PF_MAX_ICID_1_RT_OFFSET                            	1
#define DORQ_REG_PF_MAX_ICID_2_RT_OFFSET                            	2
#define DORQ_REG_PF_MAX_ICID_3_RT_OFFSET                            	3
#define DORQ_REG_PF_MAX_ICID_4_RT_OFFSET                            	4
#define DORQ_REG_PF_MAX_ICID_5_RT_OFFSET                            	5
#define DORQ_REG_PF_MAX_ICID_6_RT_OFFSET                            	6
#define DORQ_REG_PF_MAX_ICID_7_RT_OFFSET                            	7
#define DORQ_REG_VF_MAX_ICID_0_RT_OFFSET                            	8
#define DORQ_REG_VF_MAX_ICID_1_RT_OFFSET                            	9
#define DORQ_REG_VF_MAX_ICID_2_RT_OFFSET                            	10
#define DORQ_REG_VF_MAX_ICID_3_RT_OFFSET                            	11
#define DORQ_REG_VF_MAX_ICID_4_RT_OFFSET                            	12
#define DORQ_REG_VF_MAX_ICID_5_RT_OFFSET                            	13
#define DORQ_REG_VF_MAX_ICID_6_RT_OFFSET                            	14
#define DORQ_REG_VF_MAX_ICID_7_RT_OFFSET                            	15
#define DORQ_REG_PF_WAKE_ALL_RT_OFFSET                              	16
#define DORQ_REG_TAG1_ETHERTYPE_RT_OFFSET                           	17
#define DORQ_REG_GLB_MAX_ICID_0_RT_OFFSET                           	18
#define DORQ_REG_GLB_MAX_ICID_1_RT_OFFSET                           	19
#define DORQ_REG_GLB_RANGE2CONN_TYPE_0_RT_OFFSET                    	20
#define DORQ_REG_GLB_RANGE2CONN_TYPE_1_RT_OFFSET                    	21
#define DORQ_REG_PRV_PF_MAX_ICID_2_RT_OFFSET                        	22
#define DORQ_REG_PRV_PF_MAX_ICID_3_RT_OFFSET                        	23
#define DORQ_REG_PRV_PF_MAX_ICID_4_RT_OFFSET                        	24
#define DORQ_REG_PRV_PF_MAX_ICID_5_RT_OFFSET                        	25
#define DORQ_REG_PRV_VF_MAX_ICID_2_RT_OFFSET                        	26
#define DORQ_REG_PRV_VF_MAX_ICID_3_RT_OFFSET                        	27
#define DORQ_REG_PRV_VF_MAX_ICID_4_RT_OFFSET                        	28
#define DORQ_REG_PRV_VF_MAX_ICID_5_RT_OFFSET                        	29
#define DORQ_REG_PRV_PF_RANGE2CONN_TYPE_2_RT_OFFSET                 	30
#define DORQ_REG_PRV_PF_RANGE2CONN_TYPE_3_RT_OFFSET                 	31
#define DORQ_REG_PRV_PF_RANGE2CONN_TYPE_4_RT_OFFSET                 	32
#define DORQ_REG_PRV_PF_RANGE2CONN_TYPE_5_RT_OFFSET                 	33
#define DORQ_REG_PRV_VF_RANGE2CONN_TYPE_2_RT_OFFSET                 	34
#define DORQ_REG_PRV_VF_RANGE2CONN_TYPE_3_RT_OFFSET                 	35
#define DORQ_REG_PRV_VF_RANGE2CONN_TYPE_4_RT_OFFSET                 	36
#define DORQ_REG_PRV_VF_RANGE2CONN_TYPE_5_RT_OFFSET                 	37
#define IGU_REG_PF_CONFIGURATION_RT_OFFSET                          	38
#define IGU_REG_VF_CONFIGURATION_RT_OFFSET                          	39
#define IGU_REG_ATTN_MSG_ADDR_L_RT_OFFSET                           	40
#define IGU_REG_ATTN_MSG_ADDR_H_RT_OFFSET                           	41
#define IGU_REG_LEADING_EDGE_LATCH_RT_OFFSET                        	42
#define IGU_REG_TRAILING_EDGE_LATCH_RT_OFFSET                       	43
#define CAU_REG_CQE_AGG_UNIT_SIZE_RT_OFFSET                         	44
#define CAU_REG_SB_VAR_MEMORY_RT_OFFSET                             	45
#define CAU_REG_SB_VAR_MEMORY_RT_SIZE                               	1024
#define CAU_REG_SB_ADDR_MEMORY_RT_OFFSET                            	1069
#define CAU_REG_SB_ADDR_MEMORY_RT_SIZE                              	1024
#define CAU_REG_PI_MEMORY_RT_OFFSET                                 	2093
#define CAU_REG_PI_MEMORY_RT_SIZE                                   	4416
#define PRS_REG_SEARCH_RESP_INITIATOR_TYPE_RT_OFFSET                	6509
#define PRS_REG_TASK_ID_MAX_INITIATOR_PF_RT_OFFSET                  	6510
#define PRS_REG_TASK_ID_MAX_INITIATOR_VF_RT_OFFSET                  	6511
#define PRS_REG_TASK_ID_MAX_TARGET_PF_RT_OFFSET                     	6512
#define PRS_REG_TASK_ID_MAX_TARGET_VF_RT_OFFSET                     	6513
#define PRS_REG_SEARCH_TCP_RT_OFFSET                                	6514
#define PRS_REG_SEARCH_FCOE_RT_OFFSET                               	6515
#define PRS_REG_SEARCH_ROCE_RT_OFFSET                               	6516
#define PRS_REG_ROCE_DEST_QP_MAX_VF_RT_OFFSET                       	6517
#define PRS_REG_ROCE_DEST_QP_MAX_PF_RT_OFFSET                       	6518
#define PRS_REG_SEARCH_OPENFLOW_RT_OFFSET                           	6519
#define PRS_REG_SEARCH_NON_IP_AS_OPENFLOW_RT_OFFSET                 	6520
#define PRS_REG_OPENFLOW_SUPPORT_ONLY_KNOWN_OVER_IP_RT_OFFSET       	6521
#define PRS_REG_OPENFLOW_SEARCH_KEY_MASK_RT_OFFSET                  	6522
#define PRS_REG_TAG_ETHERTYPE_0_RT_OFFSET                           	6523
#define PRS_REG_LIGHT_L2_ETHERTYPE_EN_RT_OFFSET                     	6524
#define SRC_REG_FIRSTFREE_RT_OFFSET                                 	6525
#define SRC_REG_FIRSTFREE_RT_SIZE                                   	2
#define SRC_REG_LASTFREE_RT_OFFSET                                  	6527
#define SRC_REG_LASTFREE_RT_SIZE                                    	2
#define SRC_REG_COUNTFREE_RT_OFFSET                                 	6529
#define SRC_REG_NUMBER_HASH_BITS_RT_OFFSET                          	6530
#define PSWRQ2_REG_CDUT_P_SIZE_RT_OFFSET                            	6531
#define PSWRQ2_REG_CDUC_P_SIZE_RT_OFFSET                            	6532
#define PSWRQ2_REG_TM_P_SIZE_RT_OFFSET                              	6533
#define PSWRQ2_REG_QM_P_SIZE_RT_OFFSET                              	6534
#define PSWRQ2_REG_SRC_P_SIZE_RT_OFFSET                             	6535
#define PSWRQ2_REG_TSDM_P_SIZE_RT_OFFSET                            	6536
#define PSWRQ2_REG_TM_FIRST_ILT_RT_OFFSET                           	6537
#define PSWRQ2_REG_TM_LAST_ILT_RT_OFFSET                            	6538
#define PSWRQ2_REG_QM_FIRST_ILT_RT_OFFSET                           	6539
#define PSWRQ2_REG_QM_LAST_ILT_RT_OFFSET                            	6540
#define PSWRQ2_REG_SRC_FIRST_ILT_RT_OFFSET                          	6541
#define PSWRQ2_REG_SRC_LAST_ILT_RT_OFFSET                           	6542
#define PSWRQ2_REG_CDUC_FIRST_ILT_RT_OFFSET                         	6543
#define PSWRQ2_REG_CDUC_LAST_ILT_RT_OFFSET                          	6544
#define PSWRQ2_REG_CDUT_FIRST_ILT_RT_OFFSET                         	6545
#define PSWRQ2_REG_CDUT_LAST_ILT_RT_OFFSET                          	6546
#define PSWRQ2_REG_TSDM_FIRST_ILT_RT_OFFSET                         	6547
#define PSWRQ2_REG_TSDM_LAST_ILT_RT_OFFSET                          	6548
#define PSWRQ2_REG_TM_NUMBER_OF_PF_BLOCKS_RT_OFFSET                 	6549
#define PSWRQ2_REG_CDUT_NUMBER_OF_PF_BLOCKS_RT_OFFSET               	6550
#define PSWRQ2_REG_CDUC_NUMBER_OF_PF_BLOCKS_RT_OFFSET               	6551
#define PSWRQ2_REG_TM_VF_BLOCKS_RT_OFFSET                           	6552
#define PSWRQ2_REG_CDUT_VF_BLOCKS_RT_OFFSET                         	6553
#define PSWRQ2_REG_CDUC_VF_BLOCKS_RT_OFFSET                         	6554
#define PSWRQ2_REG_TM_BLOCKS_FACTOR_RT_OFFSET                       	6555
#define PSWRQ2_REG_CDUT_BLOCKS_FACTOR_RT_OFFSET                     	6556
#define PSWRQ2_REG_CDUC_BLOCKS_FACTOR_RT_OFFSET                     	6557
#define PSWRQ2_REG_VF_BASE_RT_OFFSET                                	6558
#define PSWRQ2_REG_VF_LAST_ILT_RT_OFFSET                            	6559
#define PSWRQ2_REG_DRAM_ALIGN_WR_RT_OFFSET                          	6560
#define PSWRQ2_REG_DRAM_ALIGN_RD_RT_OFFSET                          	6561
#define PSWRQ2_REG_TGSRC_FIRST_ILT_RT_OFFSET                        	6562
#define PSWRQ2_REG_RGSRC_FIRST_ILT_RT_OFFSET                        	6563
#define PSWRQ2_REG_TGSRC_LAST_ILT_RT_OFFSET                         	6564
#define PSWRQ2_REG_RGSRC_LAST_ILT_RT_OFFSET                         	6565
#define PSWRQ2_REG_ILT_MEMORY_RT_OFFSET                             	6566
#define PSWRQ2_REG_ILT_MEMORY_RT_SIZE                               	26414
#define PGLUE_REG_B_VF_BASE_RT_OFFSET                               	32980
#define PGLUE_REG_B_MSDM_OFFSET_MASK_B_RT_OFFSET                    	32981
#define PGLUE_REG_B_MSDM_VF_SHIFT_B_RT_OFFSET                       	32982
#define PGLUE_REG_B_CACHE_LINE_SIZE_RT_OFFSET                       	32983
#define PGLUE_REG_B_PF_BAR0_SIZE_RT_OFFSET                          	32984
#define PGLUE_REG_B_PF_BAR1_SIZE_RT_OFFSET                          	32985
#define PGLUE_REG_B_VF_BAR1_SIZE_RT_OFFSET                          	32986
#define TM_REG_VF_ENABLE_CONN_RT_OFFSET                             	32987
#define TM_REG_PF_ENABLE_CONN_RT_OFFSET                             	32988
#define TM_REG_PF_ENABLE_TASK_RT_OFFSET                             	32989
#define TM_REG_GROUP_SIZE_RESOLUTION_CONN_RT_OFFSET                 	32990
#define TM_REG_GROUP_SIZE_RESOLUTION_TASK_RT_OFFSET                 	32991
#define TM_REG_CONFIG_CONN_MEM_RT_OFFSET                            	32992
#define TM_REG_CONFIG_CONN_MEM_RT_SIZE                              	416
#define TM_REG_CONFIG_TASK_MEM_RT_OFFSET                            	33408
#define TM_REG_CONFIG_TASK_MEM_RT_SIZE                              	608
#define QM_REG_MAXPQSIZE_0_RT_OFFSET                                	34016
#define QM_REG_MAXPQSIZE_1_RT_OFFSET                                	34017
#define QM_REG_MAXPQSIZE_2_RT_OFFSET                                	34018
#define QM_REG_MAXPQSIZETXSEL_0_RT_OFFSET                           	34019
#define QM_REG_MAXPQSIZETXSEL_1_RT_OFFSET                           	34020
#define QM_REG_MAXPQSIZETXSEL_2_RT_OFFSET                           	34021
#define QM_REG_MAXPQSIZETXSEL_3_RT_OFFSET                           	34022
#define QM_REG_MAXPQSIZETXSEL_4_RT_OFFSET                           	34023
#define QM_REG_MAXPQSIZETXSEL_5_RT_OFFSET                           	34024
#define QM_REG_MAXPQSIZETXSEL_6_RT_OFFSET                           	34025
#define QM_REG_MAXPQSIZETXSEL_7_RT_OFFSET                           	34026
#define QM_REG_MAXPQSIZETXSEL_8_RT_OFFSET                           	34027
#define QM_REG_MAXPQSIZETXSEL_9_RT_OFFSET                           	34028
#define QM_REG_MAXPQSIZETXSEL_10_RT_OFFSET                          	34029
#define QM_REG_MAXPQSIZETXSEL_11_RT_OFFSET                          	34030
#define QM_REG_MAXPQSIZETXSEL_12_RT_OFFSET                          	34031
#define QM_REG_MAXPQSIZETXSEL_13_RT_OFFSET                          	34032
#define QM_REG_MAXPQSIZETXSEL_14_RT_OFFSET                          	34033
#define QM_REG_MAXPQSIZETXSEL_15_RT_OFFSET                          	34034
#define QM_REG_MAXPQSIZETXSEL_16_RT_OFFSET                          	34035
#define QM_REG_MAXPQSIZETXSEL_17_RT_OFFSET                          	34036
#define QM_REG_MAXPQSIZETXSEL_18_RT_OFFSET                          	34037
#define QM_REG_MAXPQSIZETXSEL_19_RT_OFFSET                          	34038
#define QM_REG_MAXPQSIZETXSEL_20_RT_OFFSET                          	34039
#define QM_REG_MAXPQSIZETXSEL_21_RT_OFFSET                          	34040
#define QM_REG_MAXPQSIZETXSEL_22_RT_OFFSET                          	34041
#define QM_REG_MAXPQSIZETXSEL_23_RT_OFFSET                          	34042
#define QM_REG_MAXPQSIZETXSEL_24_RT_OFFSET                          	34043
#define QM_REG_MAXPQSIZETXSEL_25_RT_OFFSET                          	34044
#define QM_REG_MAXPQSIZETXSEL_26_RT_OFFSET                          	34045
#define QM_REG_MAXPQSIZETXSEL_27_RT_OFFSET                          	34046
#define QM_REG_MAXPQSIZETXSEL_28_RT_OFFSET                          	34047
#define QM_REG_MAXPQSIZETXSEL_29_RT_OFFSET                          	34048
#define QM_REG_MAXPQSIZETXSEL_30_RT_OFFSET                          	34049
#define QM_REG_MAXPQSIZETXSEL_31_RT_OFFSET                          	34050
#define QM_REG_MAXPQSIZETXSEL_32_RT_OFFSET                          	34051
#define QM_REG_MAXPQSIZETXSEL_33_RT_OFFSET                          	34052
#define QM_REG_MAXPQSIZETXSEL_34_RT_OFFSET                          	34053
#define QM_REG_MAXPQSIZETXSEL_35_RT_OFFSET                          	34054
#define QM_REG_MAXPQSIZETXSEL_36_RT_OFFSET                          	34055
#define QM_REG_MAXPQSIZETXSEL_37_RT_OFFSET                          	34056
#define QM_REG_MAXPQSIZETXSEL_38_RT_OFFSET                          	34057
#define QM_REG_MAXPQSIZETXSEL_39_RT_OFFSET                          	34058
#define QM_REG_MAXPQSIZETXSEL_40_RT_OFFSET                          	34059
#define QM_REG_MAXPQSIZETXSEL_41_RT_OFFSET                          	34060
#define QM_REG_MAXPQSIZETXSEL_42_RT_OFFSET                          	34061
#define QM_REG_MAXPQSIZETXSEL_43_RT_OFFSET                          	34062
#define QM_REG_MAXPQSIZETXSEL_44_RT_OFFSET                          	34063
#define QM_REG_MAXPQSIZETXSEL_45_RT_OFFSET                          	34064
#define QM_REG_MAXPQSIZETXSEL_46_RT_OFFSET                          	34065
#define QM_REG_MAXPQSIZETXSEL_47_RT_OFFSET                          	34066
#define QM_REG_MAXPQSIZETXSEL_48_RT_OFFSET                          	34067
#define QM_REG_MAXPQSIZETXSEL_49_RT_OFFSET                          	34068
#define QM_REG_MAXPQSIZETXSEL_50_RT_OFFSET                          	34069
#define QM_REG_MAXPQSIZETXSEL_51_RT_OFFSET                          	34070
#define QM_REG_MAXPQSIZETXSEL_52_RT_OFFSET                          	34071
#define QM_REG_MAXPQSIZETXSEL_53_RT_OFFSET                          	34072
#define QM_REG_MAXPQSIZETXSEL_54_RT_OFFSET                          	34073
#define QM_REG_MAXPQSIZETXSEL_55_RT_OFFSET                          	34074
#define QM_REG_MAXPQSIZETXSEL_56_RT_OFFSET                          	34075
#define QM_REG_MAXPQSIZETXSEL_57_RT_OFFSET                          	34076
#define QM_REG_MAXPQSIZETXSEL_58_RT_OFFSET                          	34077
#define QM_REG_MAXPQSIZETXSEL_59_RT_OFFSET                          	34078
#define QM_REG_MAXPQSIZETXSEL_60_RT_OFFSET                          	34079
#define QM_REG_MAXPQSIZETXSEL_61_RT_OFFSET                          	34080
#define QM_REG_MAXPQSIZETXSEL_62_RT_OFFSET                          	34081
#define QM_REG_MAXPQSIZETXSEL_63_RT_OFFSET                          	34082
#define QM_REG_BASEADDROTHERPQ_RT_OFFSET                            	34083
#define QM_REG_BASEADDROTHERPQ_RT_SIZE                              	128
#define QM_REG_PTRTBLOTHER_RT_OFFSET                                	34211
#define QM_REG_PTRTBLOTHER_RT_SIZE                                  	256
#define QM_REG_AFULLQMBYPTHRPFWFQ_RT_OFFSET                         	34467
#define QM_REG_AFULLQMBYPTHRVPWFQ_RT_OFFSET                         	34468
#define QM_REG_AFULLQMBYPTHRPFRL_RT_OFFSET                          	34469
#define QM_REG_AFULLQMBYPTHRGLBLRL_RT_OFFSET                        	34470
#define QM_REG_AFULLOPRTNSTCCRDMASK_RT_OFFSET                       	34471
#define QM_REG_WRROTHERPQGRP_0_RT_OFFSET                            	34472
#define QM_REG_WRROTHERPQGRP_1_RT_OFFSET                            	34473
#define QM_REG_WRROTHERPQGRP_2_RT_OFFSET                            	34474
#define QM_REG_WRROTHERPQGRP_3_RT_OFFSET                            	34475
#define QM_REG_WRROTHERPQGRP_4_RT_OFFSET                            	34476
#define QM_REG_WRROTHERPQGRP_5_RT_OFFSET                            	34477
#define QM_REG_WRROTHERPQGRP_6_RT_OFFSET                            	34478
#define QM_REG_WRROTHERPQGRP_7_RT_OFFSET                            	34479
#define QM_REG_WRROTHERPQGRP_8_RT_OFFSET                            	34480
#define QM_REG_WRROTHERPQGRP_9_RT_OFFSET                            	34481
#define QM_REG_WRROTHERPQGRP_10_RT_OFFSET                           	34482
#define QM_REG_WRROTHERPQGRP_11_RT_OFFSET                           	34483
#define QM_REG_WRROTHERPQGRP_12_RT_OFFSET                           	34484
#define QM_REG_WRROTHERPQGRP_13_RT_OFFSET                           	34485
#define QM_REG_WRROTHERPQGRP_14_RT_OFFSET                           	34486
#define QM_REG_WRROTHERPQGRP_15_RT_OFFSET                           	34487
#define QM_REG_WRROTHERGRPWEIGHT_0_RT_OFFSET                        	34488
#define QM_REG_WRROTHERGRPWEIGHT_1_RT_OFFSET                        	34489
#define QM_REG_WRROTHERGRPWEIGHT_2_RT_OFFSET                        	34490
#define QM_REG_WRROTHERGRPWEIGHT_3_RT_OFFSET                        	34491
#define QM_REG_WRRTXGRPWEIGHT_0_RT_OFFSET                           	34492
#define QM_REG_WRRTXGRPWEIGHT_1_RT_OFFSET                           	34493
#define QM_REG_PQTX2PF_0_RT_OFFSET                                  	34494
#define QM_REG_PQTX2PF_1_RT_OFFSET                                  	34495
#define QM_REG_PQTX2PF_2_RT_OFFSET                                  	34496
#define QM_REG_PQTX2PF_3_RT_OFFSET                                  	34497
#define QM_REG_PQTX2PF_4_RT_OFFSET                                  	34498
#define QM_REG_PQTX2PF_5_RT_OFFSET                                  	34499
#define QM_REG_PQTX2PF_6_RT_OFFSET                                  	34500
#define QM_REG_PQTX2PF_7_RT_OFFSET                                  	34501
#define QM_REG_PQTX2PF_8_RT_OFFSET                                  	34502
#define QM_REG_PQTX2PF_9_RT_OFFSET                                  	34503
#define QM_REG_PQTX2PF_10_RT_OFFSET                                 	34504
#define QM_REG_PQTX2PF_11_RT_OFFSET                                 	34505
#define QM_REG_PQTX2PF_12_RT_OFFSET                                 	34506
#define QM_REG_PQTX2PF_13_RT_OFFSET                                 	34507
#define QM_REG_PQTX2PF_14_RT_OFFSET                                 	34508
#define QM_REG_PQTX2PF_15_RT_OFFSET                                 	34509
#define QM_REG_PQTX2PF_16_RT_OFFSET                                 	34510
#define QM_REG_PQTX2PF_17_RT_OFFSET                                 	34511
#define QM_REG_PQTX2PF_18_RT_OFFSET                                 	34512
#define QM_REG_PQTX2PF_19_RT_OFFSET                                 	34513
#define QM_REG_PQTX2PF_20_RT_OFFSET                                 	34514
#define QM_REG_PQTX2PF_21_RT_OFFSET                                 	34515
#define QM_REG_PQTX2PF_22_RT_OFFSET                                 	34516
#define QM_REG_PQTX2PF_23_RT_OFFSET                                 	34517
#define QM_REG_PQTX2PF_24_RT_OFFSET                                 	34518
#define QM_REG_PQTX2PF_25_RT_OFFSET                                 	34519
#define QM_REG_PQTX2PF_26_RT_OFFSET                                 	34520
#define QM_REG_PQTX2PF_27_RT_OFFSET                                 	34521
#define QM_REG_PQTX2PF_28_RT_OFFSET                                 	34522
#define QM_REG_PQTX2PF_29_RT_OFFSET                                 	34523
#define QM_REG_PQTX2PF_30_RT_OFFSET                                 	34524
#define QM_REG_PQTX2PF_31_RT_OFFSET                                 	34525
#define QM_REG_PQTX2PF_32_RT_OFFSET                                 	34526
#define QM_REG_PQTX2PF_33_RT_OFFSET                                 	34527
#define QM_REG_PQTX2PF_34_RT_OFFSET                                 	34528
#define QM_REG_PQTX2PF_35_RT_OFFSET                                 	34529
#define QM_REG_PQTX2PF_36_RT_OFFSET                                 	34530
#define QM_REG_PQTX2PF_37_RT_OFFSET                                 	34531
#define QM_REG_PQTX2PF_38_RT_OFFSET                                 	34532
#define QM_REG_PQTX2PF_39_RT_OFFSET                                 	34533
#define QM_REG_PQTX2PF_40_RT_OFFSET                                 	34534
#define QM_REG_PQTX2PF_41_RT_OFFSET                                 	34535
#define QM_REG_PQTX2PF_42_RT_OFFSET                                 	34536
#define QM_REG_PQTX2PF_43_RT_OFFSET                                 	34537
#define QM_REG_PQTX2PF_44_RT_OFFSET                                 	34538
#define QM_REG_PQTX2PF_45_RT_OFFSET                                 	34539
#define QM_REG_PQTX2PF_46_RT_OFFSET                                 	34540
#define QM_REG_PQTX2PF_47_RT_OFFSET                                 	34541
#define QM_REG_PQTX2PF_48_RT_OFFSET                                 	34542
#define QM_REG_PQTX2PF_49_RT_OFFSET                                 	34543
#define QM_REG_PQTX2PF_50_RT_OFFSET                                 	34544
#define QM_REG_PQTX2PF_51_RT_OFFSET                                 	34545
#define QM_REG_PQTX2PF_52_RT_OFFSET                                 	34546
#define QM_REG_PQTX2PF_53_RT_OFFSET                                 	34547
#define QM_REG_PQTX2PF_54_RT_OFFSET                                 	34548
#define QM_REG_PQTX2PF_55_RT_OFFSET                                 	34549
#define QM_REG_PQTX2PF_56_RT_OFFSET                                 	34550
#define QM_REG_PQTX2PF_57_RT_OFFSET                                 	34551
#define QM_REG_PQTX2PF_58_RT_OFFSET                                 	34552
#define QM_REG_PQTX2PF_59_RT_OFFSET                                 	34553
#define QM_REG_PQTX2PF_60_RT_OFFSET                                 	34554
#define QM_REG_PQTX2PF_61_RT_OFFSET                                 	34555
#define QM_REG_PQTX2PF_62_RT_OFFSET                                 	34556
#define QM_REG_PQTX2PF_63_RT_OFFSET                                 	34557
#define QM_REG_PQOTHER2PF_0_RT_OFFSET                               	34558
#define QM_REG_PQOTHER2PF_1_RT_OFFSET                               	34559
#define QM_REG_PQOTHER2PF_2_RT_OFFSET                               	34560
#define QM_REG_PQOTHER2PF_3_RT_OFFSET                               	34561
#define QM_REG_PQOTHER2PF_4_RT_OFFSET                               	34562
#define QM_REG_PQOTHER2PF_5_RT_OFFSET                               	34563
#define QM_REG_PQOTHER2PF_6_RT_OFFSET                               	34564
#define QM_REG_PQOTHER2PF_7_RT_OFFSET                               	34565
#define QM_REG_PQOTHER2PF_8_RT_OFFSET                               	34566
#define QM_REG_PQOTHER2PF_9_RT_OFFSET                               	34567
#define QM_REG_PQOTHER2PF_10_RT_OFFSET                              	34568
#define QM_REG_PQOTHER2PF_11_RT_OFFSET                              	34569
#define QM_REG_PQOTHER2PF_12_RT_OFFSET                              	34570
#define QM_REG_PQOTHER2PF_13_RT_OFFSET                              	34571
#define QM_REG_PQOTHER2PF_14_RT_OFFSET                              	34572
#define QM_REG_PQOTHER2PF_15_RT_OFFSET                              	34573
#define QM_REG_RLGLBLPERIOD_0_RT_OFFSET                             	34574
#define QM_REG_RLGLBLPERIOD_1_RT_OFFSET                             	34575
#define QM_REG_RLGLBLPERIODTIMER_0_RT_OFFSET                        	34576
#define QM_REG_RLGLBLPERIODTIMER_1_RT_OFFSET                        	34577
#define QM_REG_RLGLBLPERIODSEL_0_RT_OFFSET                          	34578
#define QM_REG_RLGLBLPERIODSEL_1_RT_OFFSET                          	34579
#define QM_REG_RLGLBLPERIODSEL_2_RT_OFFSET                          	34580
#define QM_REG_RLGLBLPERIODSEL_3_RT_OFFSET                          	34581
#define QM_REG_RLGLBLPERIODSEL_4_RT_OFFSET                          	34582
#define QM_REG_RLGLBLPERIODSEL_5_RT_OFFSET                          	34583
#define QM_REG_RLGLBLPERIODSEL_6_RT_OFFSET                          	34584
#define QM_REG_RLGLBLPERIODSEL_7_RT_OFFSET                          	34585
#define QM_REG_RLGLBLINCVAL_RT_OFFSET                               	34586
#define QM_REG_RLGLBLINCVAL_RT_SIZE                                 	256
#define QM_REG_RLGLBLUPPERBOUND_RT_OFFSET                           	34842
#define QM_REG_RLGLBLUPPERBOUND_RT_SIZE                             	256
#define QM_REG_RLGLBLCRD_RT_OFFSET                                  	35098
#define QM_REG_RLGLBLCRD_RT_SIZE                                    	256
#define QM_REG_RLGLBLENABLE_RT_OFFSET                               	35354
#define QM_REG_RLPFPERIOD_RT_OFFSET                                 	35355
#define QM_REG_RLPFPERIODTIMER_RT_OFFSET                            	35356
#define QM_REG_RLPFINCVAL_RT_OFFSET                                 	35357
#define QM_REG_RLPFINCVAL_RT_SIZE                                   	16
#define QM_REG_RLPFUPPERBOUND_RT_OFFSET                             	35373
#define QM_REG_RLPFUPPERBOUND_RT_SIZE                               	16
#define QM_REG_RLPFCRD_RT_OFFSET                                    	35389
#define QM_REG_RLPFCRD_RT_SIZE                                      	16
#define QM_REG_RLPFENABLE_RT_OFFSET                                 	35405
#define QM_REG_RLPFVOQENABLE_RT_OFFSET                              	35406
#define QM_REG_WFQPFWEIGHT_RT_OFFSET                                	35407
#define QM_REG_WFQPFWEIGHT_RT_SIZE                                  	16
#define QM_REG_WFQPFUPPERBOUND_RT_OFFSET                            	35423
#define QM_REG_WFQPFUPPERBOUND_RT_SIZE                              	16
#define QM_REG_WFQPFCRD_RT_OFFSET                                   	35439
#define QM_REG_WFQPFCRD_RT_SIZE                                     	256
#define QM_REG_WFQPFENABLE_RT_OFFSET                                	35695
#define QM_REG_WFQVPENABLE_RT_OFFSET                                	35696
#define QM_REG_BASEADDRTXPQ_RT_OFFSET                               	35697
#define QM_REG_BASEADDRTXPQ_RT_SIZE                                 	512
#define QM_REG_TXPQMAP_RT_OFFSET                                    	36209
#define QM_REG_TXPQMAP_RT_SIZE                                      	512
#define QM_REG_WFQVPWEIGHT_RT_OFFSET                                	36721
#define QM_REG_WFQVPWEIGHT_RT_SIZE                                  	512
#define QM_REG_WFQVPCRD_RT_OFFSET                                   	37233
#define QM_REG_WFQVPCRD_RT_SIZE                                     	512
#define QM_REG_WFQVPMAP_RT_OFFSET                                   	37745
#define QM_REG_WFQVPMAP_RT_SIZE                                     	512
#define QM_REG_PTRTBLTX_RT_OFFSET                                   	38257
#define QM_REG_PTRTBLTX_RT_SIZE                                     	1024
#define QM_REG_WFQPFCRD_MSB_RT_OFFSET                               	39281
#define QM_REG_WFQPFCRD_MSB_RT_SIZE                                 	320
#define QM_REG_VOQCRDLINE_RT_OFFSET                                 	39601
#define QM_REG_VOQCRDLINE_RT_SIZE                                   	36
#define QM_REG_VOQINITCRDLINE_RT_OFFSET                             	39637
#define QM_REG_VOQINITCRDLINE_RT_SIZE                               	36
#define QM_REG_RLPFVOQENABLE_MSB_RT_OFFSET                          	39673
#define NIG_REG_TAG_ETHERTYPE_0_RT_OFFSET                           	39674
#define NIG_REG_BRB_GATE_DNTFWD_PORT_RT_OFFSET                      	39675
#define NIG_REG_OUTER_TAG_VALUE_LIST0_RT_OFFSET                     	39676
#define NIG_REG_OUTER_TAG_VALUE_LIST1_RT_OFFSET                     	39677
#define NIG_REG_OUTER_TAG_VALUE_LIST2_RT_OFFSET                     	39678
#define NIG_REG_OUTER_TAG_VALUE_LIST3_RT_OFFSET                     	39679
#define NIG_REG_LLH_FUNC_TAGMAC_CLS_TYPE_RT_OFFSET                  	39680
#define NIG_REG_LLH_FUNC_TAG_EN_RT_OFFSET                           	39681
#define NIG_REG_LLH_FUNC_TAG_EN_RT_SIZE                             	4
#define NIG_REG_LLH_FUNC_TAG_VALUE_RT_OFFSET                        	39685
#define NIG_REG_LLH_FUNC_TAG_VALUE_RT_SIZE                          	4
#define NIG_REG_LLH_FUNC_FILTER_VALUE_RT_OFFSET                     	39689
#define NIG_REG_LLH_FUNC_FILTER_VALUE_RT_SIZE                       	32
#define NIG_REG_LLH_FUNC_FILTER_EN_RT_OFFSET                        	39721
#define NIG_REG_LLH_FUNC_FILTER_EN_RT_SIZE                          	16
#define NIG_REG_LLH_FUNC_FILTER_MODE_RT_OFFSET                      	39737
#define NIG_REG_LLH_FUNC_FILTER_MODE_RT_SIZE                        	16
#define NIG_REG_LLH_FUNC_FILTER_PROTOCOL_TYPE_RT_OFFSET             	39753
#define NIG_REG_LLH_FUNC_FILTER_PROTOCOL_TYPE_RT_SIZE               	16
#define NIG_REG_LLH_FUNC_FILTER_HDR_SEL_RT_OFFSET                   	39769
#define NIG_REG_LLH_FUNC_FILTER_HDR_SEL_RT_SIZE                     	16
#define NIG_REG_TX_EDPM_CTRL_RT_OFFSET                              	39785
#define NIG_REG_ROCE_DUPLICATE_TO_HOST_RT_OFFSET                    	39786
#define NIG_REG_PPF_TO_ENGINE_SEL_RT_OFFSET                         	39787
#define NIG_REG_PPF_TO_ENGINE_SEL_RT_SIZE                           	8
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_VALUE_RT_OFFSET              	39795
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_VALUE_RT_SIZE                	1024
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_EN_RT_OFFSET                 	40819
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_EN_RT_SIZE                   	512
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_MODE_RT_OFFSET               	41331
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_MODE_RT_SIZE                 	512
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_PROTOCOL_TYPE_RT_OFFSET      	41843
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_PROTOCOL_TYPE_RT_SIZE        	512
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_HDR_SEL_RT_OFFSET            	42355
#define NIG_REG_LLH_PF_CLS_FUNC_FILTER_HDR_SEL_RT_SIZE              	512
#define NIG_REG_LLH_PF_CLS_FILTERS_MAP_RT_OFFSET                    	42867
#define NIG_REG_LLH_PF_CLS_FILTERS_MAP_RT_SIZE                      	32
#define CDU_REG_CID_ADDR_PARAMS_RT_OFFSET                           	42899
#define CDU_REG_SEGMENT0_PARAMS_RT_OFFSET                           	42900
#define CDU_REG_SEGMENT1_PARAMS_RT_OFFSET                           	42901
#define CDU_REG_PF_SEG0_TYPE_OFFSET_RT_OFFSET                       	42902
#define CDU_REG_PF_SEG1_TYPE_OFFSET_RT_OFFSET                       	42903
#define CDU_REG_PF_SEG2_TYPE_OFFSET_RT_OFFSET                       	42904
#define CDU_REG_PF_SEG3_TYPE_OFFSET_RT_OFFSET                       	42905
#define CDU_REG_PF_FL_SEG0_TYPE_OFFSET_RT_OFFSET                    	42906
#define CDU_REG_PF_FL_SEG1_TYPE_OFFSET_RT_OFFSET                    	42907
#define CDU_REG_PF_FL_SEG2_TYPE_OFFSET_RT_OFFSET                    	42908
#define CDU_REG_PF_FL_SEG3_TYPE_OFFSET_RT_OFFSET                    	42909
#define CDU_REG_VF_SEG_TYPE_OFFSET_RT_OFFSET                        	42910
#define CDU_REG_VF_FL_SEG_TYPE_OFFSET_RT_OFFSET                     	42911
#define PBF_REG_TAG_ETHERTYPE_0_RT_OFFSET                           	42912
#define PBF_REG_BTB_SHARED_AREA_SIZE_RT_OFFSET                      	42913
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ0_RT_OFFSET                    	42914
#define PBF_REG_BTB_GUARANTEED_VOQ0_RT_OFFSET                       	42915
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ0_RT_OFFSET                	42916
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ1_RT_OFFSET                    	42917
#define PBF_REG_BTB_GUARANTEED_VOQ1_RT_OFFSET                       	42918
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ1_RT_OFFSET                	42919
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ2_RT_OFFSET                    	42920
#define PBF_REG_BTB_GUARANTEED_VOQ2_RT_OFFSET                       	42921
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ2_RT_OFFSET                	42922
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ3_RT_OFFSET                    	42923
#define PBF_REG_BTB_GUARANTEED_VOQ3_RT_OFFSET                       	42924
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ3_RT_OFFSET                	42925
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ4_RT_OFFSET                    	42926
#define PBF_REG_BTB_GUARANTEED_VOQ4_RT_OFFSET                       	42927
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ4_RT_OFFSET                	42928
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ5_RT_OFFSET                    	42929
#define PBF_REG_BTB_GUARANTEED_VOQ5_RT_OFFSET                       	42930
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ5_RT_OFFSET                	42931
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ6_RT_OFFSET                    	42932
#define PBF_REG_BTB_GUARANTEED_VOQ6_RT_OFFSET                       	42933
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ6_RT_OFFSET                	42934
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ7_RT_OFFSET                    	42935
#define PBF_REG_BTB_GUARANTEED_VOQ7_RT_OFFSET                       	42936
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ7_RT_OFFSET                	42937
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ8_RT_OFFSET                    	42938
#define PBF_REG_BTB_GUARANTEED_VOQ8_RT_OFFSET                       	42939
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ8_RT_OFFSET                	42940
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ9_RT_OFFSET                    	42941
#define PBF_REG_BTB_GUARANTEED_VOQ9_RT_OFFSET                       	42942
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ9_RT_OFFSET                	42943
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ10_RT_OFFSET                   	42944
#define PBF_REG_BTB_GUARANTEED_VOQ10_RT_OFFSET                      	42945
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ10_RT_OFFSET               	42946
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ11_RT_OFFSET                   	42947
#define PBF_REG_BTB_GUARANTEED_VOQ11_RT_OFFSET                      	42948
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ11_RT_OFFSET               	42949
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ12_RT_OFFSET                   	42950
#define PBF_REG_BTB_GUARANTEED_VOQ12_RT_OFFSET                      	42951
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ12_RT_OFFSET               	42952
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ13_RT_OFFSET                   	42953
#define PBF_REG_BTB_GUARANTEED_VOQ13_RT_OFFSET                      	42954
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ13_RT_OFFSET               	42955
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ14_RT_OFFSET                   	42956
#define PBF_REG_BTB_GUARANTEED_VOQ14_RT_OFFSET                      	42957
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ14_RT_OFFSET               	42958
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ15_RT_OFFSET                   	42959
#define PBF_REG_BTB_GUARANTEED_VOQ15_RT_OFFSET                      	42960
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ15_RT_OFFSET               	42961
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ16_RT_OFFSET                   	42962
#define PBF_REG_BTB_GUARANTEED_VOQ16_RT_OFFSET                      	42963
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ16_RT_OFFSET               	42964
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ17_RT_OFFSET                   	42965
#define PBF_REG_BTB_GUARANTEED_VOQ17_RT_OFFSET                      	42966
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ17_RT_OFFSET               	42967
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ18_RT_OFFSET                   	42968
#define PBF_REG_BTB_GUARANTEED_VOQ18_RT_OFFSET                      	42969
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ18_RT_OFFSET               	42970
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ19_RT_OFFSET                   	42971
#define PBF_REG_BTB_GUARANTEED_VOQ19_RT_OFFSET                      	42972
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ19_RT_OFFSET               	42973
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ20_RT_OFFSET                   	42974
#define PBF_REG_BTB_GUARANTEED_VOQ20_RT_OFFSET                      	42975
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ20_RT_OFFSET               	42976
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ21_RT_OFFSET                   	42977
#define PBF_REG_BTB_GUARANTEED_VOQ21_RT_OFFSET                      	42978
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ21_RT_OFFSET               	42979
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ22_RT_OFFSET                   	42980
#define PBF_REG_BTB_GUARANTEED_VOQ22_RT_OFFSET                      	42981
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ22_RT_OFFSET               	42982
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ23_RT_OFFSET                   	42983
#define PBF_REG_BTB_GUARANTEED_VOQ23_RT_OFFSET                      	42984
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ23_RT_OFFSET               	42985
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ24_RT_OFFSET                   	42986
#define PBF_REG_BTB_GUARANTEED_VOQ24_RT_OFFSET                      	42987
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ24_RT_OFFSET               	42988
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ25_RT_OFFSET                   	42989
#define PBF_REG_BTB_GUARANTEED_VOQ25_RT_OFFSET                      	42990
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ25_RT_OFFSET               	42991
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ26_RT_OFFSET                   	42992
#define PBF_REG_BTB_GUARANTEED_VOQ26_RT_OFFSET                      	42993
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ26_RT_OFFSET               	42994
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ27_RT_OFFSET                   	42995
#define PBF_REG_BTB_GUARANTEED_VOQ27_RT_OFFSET                      	42996
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ27_RT_OFFSET               	42997
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ28_RT_OFFSET                   	42998
#define PBF_REG_BTB_GUARANTEED_VOQ28_RT_OFFSET                      	42999
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ28_RT_OFFSET               	43000
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ29_RT_OFFSET                   	43001
#define PBF_REG_BTB_GUARANTEED_VOQ29_RT_OFFSET                      	43002
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ29_RT_OFFSET               	43003
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ30_RT_OFFSET                   	43004
#define PBF_REG_BTB_GUARANTEED_VOQ30_RT_OFFSET                      	43005
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ30_RT_OFFSET               	43006
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ31_RT_OFFSET                   	43007
#define PBF_REG_BTB_GUARANTEED_VOQ31_RT_OFFSET                      	43008
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ31_RT_OFFSET               	43009
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ32_RT_OFFSET                   	43010
#define PBF_REG_BTB_GUARANTEED_VOQ32_RT_OFFSET                      	43011
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ32_RT_OFFSET               	43012
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ33_RT_OFFSET                   	43013
#define PBF_REG_BTB_GUARANTEED_VOQ33_RT_OFFSET                      	43014
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ33_RT_OFFSET               	43015
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ34_RT_OFFSET                   	43016
#define PBF_REG_BTB_GUARANTEED_VOQ34_RT_OFFSET                      	43017
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ34_RT_OFFSET               	43018
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ35_RT_OFFSET                   	43019
#define PBF_REG_BTB_GUARANTEED_VOQ35_RT_OFFSET                      	43020
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ35_RT_OFFSET               	43021
#define XCM_REG_CON_PHY_Q3_RT_OFFSET                                	43022

#define RUNTIME_ARRAY_SIZE 43023

/* Init Callbacks */
#define DMAE_READY_CB                                               	0

#endif /* __RT_DEFS_H__ */
