/*-
 * Copyright (c) 2020-2021 The FreeBSD Foundation
 * Copyright (c) 2021-2022 Bjoern A. Zeeb
 *
 * This software was developed by Björn Zeeb under sponsorship from
 * the FreeBSD Foundation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	_LINUXKPI_NET_REGULATORY_H
#define	_LINUXKPI_NET_REGULATORY_H

enum environment_cap {
	ENVIRON_INDOOR		= 1,	/* keep != 0 */
};

#define	REG_RULE(_begin, _end, _bw, _mag, _meirp, _flags)		\
{									\
	.flags = (_flags),						\
	.freq_range.start_freq_khz = MHZ_TO_KHZ(_begin),		\
	.freq_range.end_freq_khz = MHZ_TO_KHZ(_end),			\
	.freq_range.max_bandwidth_khz = MHZ_TO_KHZ(_bw),		\
	.power_rule.max_antenna_gain = DBI_TO_MBI(_mag),		\
	.power_rule.max_eirp = DBI_TO_MBI(_meirp),			\
}

#endif	/* _LINUXKPI_NET_REGULATORY_H */
